#!/bin/sh

PAGES_ROLLER_RESULT_OK=0
PAGES_ROLLER_RESULT_ERROR=1
PAGES_ROLLER_RESULT_CODE="${PAGES_ROLLER_RESULT_ERROR}"

PAGES_ROLLER_RESULT_MSG=""
PAGES_ROLLER_RESULT_ROLLING=0

pages_roller() {
	#debug_print 'in function "pages_roller"'
	
	local page_array=(${1})
	local index=0
	local u_page=""
	local page_result_code=
	local page_result_msg=
	local page_result_rolling=0

	# #debug_print "*: ${page_array[*]}"
	# #debug_print "0: ${page_array[0]}"
	# #debug_print "1: ${page_array[1]}"
	# #debug_print "2: ${page_array[2]}"
	
	while [ 1 ];
	do
        #debug_print "${page_array[$index]}"
		local page="${page_array[$index]}"
		${page}

		# get page result
		declare -u u_page="${page}"
		
		eval page_result_title=\${${u_page}_TITLE}
                eval page_result_code=\${${u_page}_RESULT_CODE}
		eval page_result_msg=\${${u_page}_RESULT_MSG}
		eval page_result_rolling=\${${u_page}_RESULT_ROLLING}
		# echo "u_page: ${u_page}"
		# echo "page_result_code: ${page_result_code}"
		# echo "page_result_msg: ${page_result_msg}"
		# echo "page_result_rolling: ${page_result_rolling}"


		# error handling - page result code is non-zero
		echo "page result:${page_result_code}"
		if [ ${page_result_code} -ne 0 ]; then
			#debug_print "Error occurs, error_code: ${page_result_code}, error_msg: ${page_result_msg}"
			
			page_error "${page_result_title}" "${page_result_code}" "${page_result_msg}"
		fi
		
		
		# error handling - page index out of range
		echo "index:${index}"
		echo "page result rolling:${page_result_rolling}"
		local tmp_index=$(( ${index} + ${page_result_rolling} ))
		echo "temp index:" . ${tmp_index}
		if [ "${tmp_index}" -lt 0 ] || [ "${tmp_index}" -ge "${#page_array[@]}" ]; then
			#debug_print "PageIndexOutOfRange, CurrentPage: ${page}, CurrentPageIndex: ${index}, PageRolling: ${page_result_rolling}, PageArraySize: ${#page_array[@]}"
            
            PAGES_ROLLER_RESULT_CODE="${PAGES_ROLLER_RESULT_OK}"
			return
		fi
		
		# rolling page
		index=${tmp_index}
	done
}

page_error() {
	#debug_print "${0}" "${LINENO}" 'entering page_error'

        local error_title="${1}"
	local error_code="${2:-1}"
	local error_msg="${3:-None}"
	# #debug_print "${0}" "${LINENO}" "CONS_BACK_TITLE: ${CONS_BACK_TITLE}"
	# #debug_print "${0}" "${LINENO}" "error_code: ${error_code}"
	# #debug_print "${0}" "${LINENO}" "error_msg: ${error_msg}"
	# #debug_print "${0}" "${LINENO}" "CONS_BOX_ERROR_HEIGHT: ${CONS_BOX_ERROR_HEIGHT}"
	# #debug_print "${0}" "${LINENO}" "CONS_BOX_ERROR_WIDTH: ${CONS_BOX_ERROR_WIDTH}"
        if [ "${error_title}" = "" ]; then
            error_title="${ERROR_TITLE}"
        fi
	
	dialog \
		--title     "${error_title}" \
		--backtitle "${CONS_BACK_TITLE}" \
		--msgbox    "${error_msg}" \
		            "${CONS_BOX_HEIGHT}" \
					"${CONS_BOX_ERROR_WIDTH}"
}
